import java.util.ArrayList;

public class Employer extends Person {

	private ArrayList<Person> employees = new ArrayList<Person>();
		
	/**Constructor: calls the person constructor, and creates an arraylist of persons as employees. **/
	public Employer(String name, String password, double pocketMoney){
		super(name, password, pocketMoney);
	}
	
	/** String representation of this Employer **/
	public String toString() {
		return "Employer " + getName() + " has $" + getPocketMoney() + " in cash and a total net worth of $" + getNetWorth() + " including what's in " + getAccounts().size() + " accounts. He/she has " + employees.size() + " employees.";
	}
	
	/** Adds an employee to the arraylist of employees **/
	public void addEmployee(Person p){
		employees.add(p);
	}
	
	/** Removes an employee to the arraylist of employees **/
	public void removeEmployee(Person p){
		employees.remove(p);
	}
}
